import flixel.FlxSprite;
import funkin.game.PlayState;
import flixel.math.FlxMath;
import flixel.util.FlxAxes;
import flixel.addons.display.FlxBackdrop;


function postCreate() {
   GameOverSubstate.script = 'data/scripts/gameovers/hiver';
   
   cloud1 = new FlxBackdrop(Paths.image("stages/hiver/cloudstill1"), FlxAxes.X);
   cloud1.velocity.set(-15, 0);
   cloud1.spacing.set(900, 0);
   cloud1.scrollFactor.set(0.07, 0.07);
   cloud1.x = -350;
   cloud1.y = -350;
   insert(members.indexOf(wall), cloud1); 
   add(cloud1);

   cloud2 = new FlxBackdrop(Paths.image("stages/hiver/cloudstill2"), FlxAxes.X);
   cloud2.velocity.set(-50, 0);
   cloud2.spacing.set(500, 0);
   cloud2.scrollFactor.set(0.105, 0.105);
   cloud2.x = 700;
   cloud2.y = 60;
   insert(members.indexOf(wall), cloud2); 
   add(cloud2);

   cloud3 = new FlxBackdrop(Paths.image("stages/hiver/cloudstill3"), FlxAxes.X);
   cloud3.velocity.set(-110, 0);
   cloud3.spacing.set(1200, 0);
   cloud3.scrollFactor.set(0.15, 0.15);
   cloud3.x = -510;
   cloud3.y = 330;
   insert(members.indexOf(wall), cloud3); 
   add(cloud3);
   
   for (i in [sky, cloud1, cloud2, cloud3])
   i.color = 0xFFfdbb55;
}

function bgColorChange() for (i in [sky, cloud1, cloud2, cloud3]) FlxTween.color(i, 1.7, 0xFFfdbb55, FlxColor.WHITE);

function beatHit(beat)
{
	// too fast for *every* beat
	if (beat % 4 == 0)
		shade.alpha = 1;
}

function update(elapsed)
{
	shade.alpha = FlxMath.lerp(shade.alpha, 0.45, elapsed * 1.5);
}

		


